"""Auto-generated stub file for GTA V ScriptHookVDotNet"""

from typing import Any, List, Dict, Optional, Iterable, ClassVar, Tuple, Callable, TypeVar, overload, Union
from enum import Enum

from GTA import (
    Blip,
    Camera,
    Checkpoint,
    Entity,
    Game,
    Model,
    Ped,
    PedHash,
    Player,
    Prop,
    Vehicle,
    VehicleHash,
    Weapon,
    WeaponHash,
    World
)
from GTA.Math import Matrix, Quaternion, Vector2, Vector3

class CustomHelper:
    @overload
    def Start(self) -> None: ...
    @overload
    def Start(self, duration: int) -> None: ...
    def Start(self, *args: Any, **kwargs: Any) -> Any: ...
    def Update(self) -> None: ...
    def Stop(self) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: bool) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: int) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: float) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: str) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: Vector3) -> None: ...
    def SetArgument(self, *args: Any, **kwargs: Any) -> Any: ...
    def ResetArguments(self) -> None: ...
    def ToString(self) -> str: ...

class Euphoria:
    ActivePose: ActivePoseHelper
    ApplyImpulse: ApplyImpulseHelper
    ApplyBulletImpulse: ApplyBulletImpulseHelper
    BodyRelax: BodyRelaxHelper
    ConfigureBalance: ConfigureBalanceHelper
    ConfigureBalanceReset: ConfigureBalanceResetHelper
    ConfigureSelfAvoidance: ConfigureSelfAvoidanceHelper
    ConfigureBullets: ConfigureBulletsHelper
    ConfigureBulletsExtra: ConfigureBulletsExtraHelper
    ConfigureLimits: ConfigureLimitsHelper
    ConfigureSoftLimit: ConfigureSoftLimitHelper
    ConfigureShotInjuredArm: ConfigureShotInjuredArmHelper
    ConfigureShotInjuredLeg: ConfigureShotInjuredLegHelper
    DefineAttachedObject: DefineAttachedObjectHelper
    ForceToBodyPart: ForceToBodyPartHelper
    LeanInDirection: LeanInDirectionHelper
    LeanRandom: LeanRandomHelper
    LeanToPosition: LeanToPositionHelper
    LeanTowardsObject: LeanTowardsObjectHelper
    HipsLeanInDirection: HipsLeanInDirectionHelper
    HipsLeanRandom: HipsLeanRandomHelper
    HipsLeanToPosition: HipsLeanToPositionHelper
    HipsLeanTowardsObject: HipsLeanTowardsObjectHelper
    ForceLeanInDirection: ForceLeanInDirectionHelper
    ForceLeanRandom: ForceLeanRandomHelper
    ForceLeanToPosition: ForceLeanToPositionHelper
    ForceLeanTowardsObject: ForceLeanTowardsObjectHelper
    SetStiffness: SetStiffnessHelper
    SetMuscleStiffness: SetMuscleStiffnessHelper
    SetWeaponMode: SetWeaponModeHelper
    RegisterWeapon: RegisterWeaponHelper
    ShotRelax: ShotRelaxHelper
    FireWeapon: FireWeaponHelper
    ConfigureConstraints: ConfigureConstraintsHelper
    StayUpright: StayUprightHelper
    StopAllBehaviors: StopAllBehaviorsHelper
    SetCharacterStrength: SetCharacterStrengthHelper
    SetCharacterHealth: SetCharacterHealthHelper
    SetFallingReaction: SetFallingReactionHelper
    SetCharacterUnderwater: SetCharacterUnderwaterHelper
    SetCharacterCollisions: SetCharacterCollisionsHelper
    SetCharacterDamping: SetCharacterDampingHelper
    SetFrictionScale: SetFrictionScaleHelper
    AnimPose: AnimPoseHelper
    ArmsWindmill: ArmsWindmillHelper
    ArmsWindmillAdaptive: ArmsWindmillAdaptiveHelper
    BalancerCollisionsReaction: BalancerCollisionsReactionHelper
    BodyBalance: BodyBalanceHelper
    BodyFoetal: BodyFoetalHelper
    BodyRollUp: BodyRollUpHelper
    BodyWrithe: BodyWritheHelper
    BraceForImpact: BraceForImpactHelper
    Buoyancy: BuoyancyHelper
    CatchFall: CatchFallHelper
    Electrocute: ElectrocuteHelper
    FallOverWall: FallOverWallHelper
    Grab: GrabHelper
    HeadLook: HeadLookHelper
    HighFall: HighFallHelper
    IncomingTransforms: IncomingTransformsHelper
    InjuredOnGround: InjuredOnGroundHelper
    Carried: CarriedHelper
    Dangle: DangleHelper
    OnFire: OnFireHelper
    PedalLegs: PedalLegsHelper
    PointArm: PointArmHelper
    PointGun: PointGunHelper
    PointGunExtra: PointGunExtraHelper
    RollDownStairs: RollDownStairsHelper
    Shot: ShotHelper
    ShotNewBullet: ShotNewBulletHelper
    ShotSnap: ShotSnapHelper
    ShotShockSpin: ShotShockSpinHelper
    ShotFallToKnees: ShotFallToKneesHelper
    ShotFromBehind: ShotFromBehindHelper
    ShotInGuts: ShotInGutsHelper
    ShotHeadLook: ShotHeadLookHelper
    ShotConfigureArms: ShotConfigureArmsHelper
    SmartFall: SmartFallHelper
    StaggerFall: StaggerFallHelper
    Teeter: TeeterHelper
    UpperBodyFlinch: UpperBodyFlinchHelper
    Yanked: YankedHelper

class ArmDirection(Enum):
    Adaptive = 0
    Forwards = 1
    Backwards = -1

class AnimSource(Enum):
    CurrentItems = 0
    PreviousItems = 1
    AnimItems = 2

class FallType(Enum):
    RampDownStiffness = 0
    DontChangeStep = 1
    ForceBalance = 2
    Slump = 3

class Synchroisation(Enum):
    NotSynced = 0
    AlwaysSynced = 1
    SyncedAtStart = 2

class TurnType(Enum):
    DontTurn = 0
    ToTarget = 1
    AwayFromTarget = 2

class TorqueMode(Enum):
    Disabled = 0
    Proportional = 1
    Additive = 2

class TorqueSpinMode(Enum):
    FromImpulse = 0
    Random = 1
    Flipping = 2

class TorqueFilterMode(Enum):
    ApplyEveryBullet = 0
    ApplyIfLastFinished = 1
    ApplyIfSpinDifferent = 2

class RbTwistAxis(Enum):
    WorldUp = 0
    CharacterComUp = 1

class WeaponMode(Enum):
    Pistol = 0
    Dual = 1
    Rifle = 2
    SideArm = 3
    PistolLeft = 4
    PistolRight = 5
    None_ = -1

class Hand(Enum):
    Left = 0
    Right = 1

class MirrorMode(Enum):
    Independant = 0
    Mirrored = 1
    Parallel = 2

class AdaptiveMode(Enum):
    NotAdaptive = 0
    OnlyDirection = 1
    DirectionAndSpeed = 2
    DirectionSpeedAndStrength = 3

class ActivePoseHelper(CustomHelper):
    Mask: str
    UseGravityCompensation: bool
    AnimSource: AnimSource
    def __init__(self, ped: Ped) -> None: ...

class ApplyImpulseHelper(CustomHelper):
    EqualizeAmount: float
    PartIndex: int
    Impulse: Vector3
    HitPoint: Vector3
    LocalHitPointInfo: bool
    LocalImpulseInfo: bool
    AngularImpulse: bool
    def __init__(self, ped: Ped) -> None: ...

class ApplyBulletImpulseHelper(CustomHelper):
    EqualizeAmount: float
    PartIndex: int
    Impulse: Vector3
    HitPoint: Vector3
    LocalHitPointInfo: bool
    ExtraShare: float
    def __init__(self, ped: Ped) -> None: ...

class BodyRelaxHelper(CustomHelper):
    Relaxation: float
    Damping: float
    Mask: str
    HoldPose: bool
    DisableJointDriving: bool
    def __init__(self, ped: Ped) -> None: ...

class ConfigureBalanceHelper(CustomHelper):
    StepHeight: float
    StepHeightInc4Step: float
    LegsApartRestep: float
    LegsTogetherRestep: float
    LegsApartMax: float
    TaperKneeStrength: bool
    LegStiffness: float
    LeftLegSwingDamping: float
    RightLegSwingDamping: float
    OpposeGravityLegs: float
    OpposeGravityAnkles: float
    LeanAcc: float
    HipLeanAcc: float
    LeanAccMax: float
    ResistAcc: float
    ResistAccMax: float
    FootSlipCompOnMovingFloor: bool
    AnkleEquilibrium: float
    ExtraFeetApart: float
    DontStepTime: float
    BalanceAbortThreshold: float
    GiveUpHeight: float
    StepClampScale: float
    StepClampScaleVariance: float
    PredictionTimeHip: float
    PredictionTime: float
    PredictionTimeVariance: float
    MaxSteps: int
    MaxBalanceTime: float
    ExtraSteps: int
    ExtraTime: float
    FallType: FallType
    FallMult: float
    FallReduceGravityComp: bool
    RampHipPitchOnFail: bool
    StableLinSpeedThresh: float
    StableRotSpeedThresh: float
    FailMustCollide: bool
    IgnoreFailure: bool
    ChangeStepTime: float
    BalanceIndefinitely: bool
    MovingFloor: bool
    AirborneStep: bool
    UseComDirTurnVelThresh: float
    MinKneeAngle: float
    FlatterSwingFeet: bool
    FlatterStaticFeet: bool
    AvoidLeg: bool
    AvoidFootWidth: float
    AvoidFeedback: float
    LeanAgainstVelocity: float
    StepDecisionThreshold: float
    StepIfInSupport: bool
    AlwaysStepWithFarthest: bool
    StandUp: bool
    DepthFudge: float
    DepthFudgeStagger: float
    FootFriction: float
    FootFrictionStagger: float
    BackwardsLeanCutoff: float
    GiveUpHeightEnd: float
    BalanceAbortThresholdEnd: float
    GiveUpRampDuration: float
    LeanToAbort: float
    def __init__(self, ped: Ped) -> None: ...

class ConfigureBalanceResetHelper(CustomHelper):
    def __init__(self, ped: Ped) -> None: ...

class ConfigureSelfAvoidanceHelper(CustomHelper):
    UseSelfAvoidance: bool
    OverwriteDragReduction: bool
    TorsoSwingFraction: float
    MaxTorsoSwingAngleRad: float
    SelfAvoidIfInSpineBoundsOnly: bool
    SelfAvoidAmount: float
    OverwriteTwist: bool
    UsePolarPathAlgorithm: bool
    Radius: float
    def __init__(self, ped: Ped) -> None: ...

class ConfigureBulletsHelper(CustomHelper):
    ImpulseSpreadOverParts: bool
    ImpulseLeakageStrengthScaled: bool
    ImpulsePeriod: float
    ImpulseTorqueScale: float
    LoosenessFix: bool
    ImpulseDelay: float
    ImpulseReductionPerShot: float
    ImpulseRecovery: float
    ImpulseMinLeakage: float
    TorqueMode: TorqueMode
    TorqueSpinMode: TorqueSpinMode
    TorqueFilterMode: TorqueFilterMode
    TorqueAlwaysSpine3: bool
    TorqueDelay: float
    TorquePeriod: float
    TorqueGain: float
    TorqueCutoff: float
    TorqueReductionPerTick: float
    LiftGain: float
    CounterImpulseDelay: float
    CounterImpulseMag: float
    CounterAfterMagReached: bool
    DoCounterImpulse: bool
    CounterImpulse2Hips: float
    ImpulseNoBalMult: float
    ImpulseBalStabStart: float
    ImpulseBalStabEnd: float
    ImpulseBalStabMult: float
    ImpulseSpineAngStart: float
    ImpulseSpineAngEnd: float
    ImpulseSpineAngMult: float
    ImpulseVelStart: float
    ImpulseVelEnd: float
    ImpulseVelMult: float
    ImpulseAirMult: float
    ImpulseAirMultStart: float
    ImpulseAirMax: float
    ImpulseAirApplyAbove: float
    ImpulseAirOn: bool
    ImpulseOneLegMult: float
    ImpulseOneLegMultStart: float
    ImpulseOneLegMax: float
    ImpulseOneLegApplyAbove: float
    ImpulseOneLegOn: bool
    RbRatio: float
    RbLowerShare: float
    RbMoment: float
    RbMaxTwistMomentArm: float
    RbMaxBroomMomentArm: float
    RbRatioAirborne: float
    RbMomentAirborne: float
    RbMaxTwistMomentArmAirborne: float
    RbMaxBroomMomentArmAirborne: float
    RbRatioOneLeg: float
    RbMomentOneLeg: float
    RbMaxTwistMomentArmOneLeg: float
    RbMaxBroomMomentArmOneLeg: float
    RbTwistAxis: RbTwistAxis
    RbPivot: bool
    def __init__(self, ped: Ped) -> None: ...

class ConfigureBulletsExtraHelper(CustomHelper):
    ImpulseSpreadOverParts: bool
    ImpulsePeriod: float
    ImpulseTorqueScale: float
    LoosenessFix: bool
    ImpulseDelay: float
    TorqueMode: TorqueMode
    TorqueSpinMode: TorqueSpinMode
    TorqueFilterMode: TorqueFilterMode
    TorqueAlwaysSpine3: bool
    TorqueDelay: float
    TorquePeriod: float
    TorqueGain: float
    TorqueCutoff: float
    TorqueReductionPerTick: float
    LiftGain: float
    CounterImpulseDelay: float
    CounterImpulseMag: float
    CounterAfterMagReached: bool
    DoCounterImpulse: bool
    CounterImpulse2Hips: float
    ImpulseNoBalMult: float
    ImpulseBalStabStart: float
    ImpulseBalStabEnd: float
    ImpulseBalStabMult: float
    ImpulseSpineAngStart: float
    ImpulseSpineAngEnd: float
    ImpulseSpineAngMult: float
    ImpulseVelStart: float
    ImpulseVelEnd: float
    ImpulseVelMult: float
    ImpulseAirMult: float
    ImpulseAirMultStart: float
    ImpulseAirMax: float
    ImpulseAirApplyAbove: float
    ImpulseAirOn: bool
    ImpulseOneLegMult: float
    ImpulseOneLegMultStart: float
    ImpulseOneLegMax: float
    ImpulseOneLegApplyAbove: float
    ImpulseOneLegOn: bool
    RbRatio: float
    RbLowerShare: float
    RbMoment: float
    RbMaxTwistMomentArm: float
    RbMaxBroomMomentArm: float
    RbRatioAirborne: float
    RbMomentAirborne: float
    RbMaxTwistMomentArmAirborne: float
    RbMaxBroomMomentArmAirborne: float
    RbRatioOneLeg: float
    RbMomentOneLeg: float
    RbMaxTwistMomentArmOneLeg: float
    RbMaxBroomMomentArmOneLeg: float
    RbTwistAxis: RbTwistAxis
    RbPivot: bool
    def __init__(self, ped: Ped) -> None: ...

class ConfigureLimitsHelper(CustomHelper):
    Mask: str
    Enable: bool
    ToDesired: bool
    Restore: bool
    ToCurAnimation: bool
    Index: int
    Lean1: float
    Lean2: float
    Twist: float
    Margin: float
    def __init__(self, ped: Ped) -> None: ...

class ConfigureSoftLimitHelper(CustomHelper):
    Index: int
    Stiffness: float
    Damping: float
    LimitAngle: float
    ApproachDirection: int
    VelocityScaled: bool
    def __init__(self, ped: Ped) -> None: ...

class ConfigureShotInjuredArmHelper(CustomHelper):
    InjuredArmTime: float
    HipYaw: float
    HipRoll: float
    ForceStepExtraHeight: float
    ForceStep: bool
    StepTurn: bool
    VelMultiplierStart: float
    VelMultiplierEnd: float
    VelForceStep: float
    VelStepTurn: float
    VelScales: bool
    def __init__(self, ped: Ped) -> None: ...

class ConfigureShotInjuredLegHelper(CustomHelper):
    TimeBeforeCollapseWoundLeg: float
    LegInjuryTime: float
    LegForceStep: bool
    LegLimpBend: float
    LegLiftTime: float
    LegInjury: float
    LegInjuryHipPitch: float
    LegInjuryLiftHipPitch: float
    LegInjurySpineBend: float
    LegInjuryLiftSpineBend: float
    def __init__(self, ped: Ped) -> None: ...

class DefineAttachedObjectHelper(CustomHelper):
    PartIndex: int
    ObjectMass: float
    WorldPos: Vector3
    def __init__(self, ped: Ped) -> None: ...

class ForceToBodyPartHelper(CustomHelper):
    PartIndex: int
    Force: Vector3
    ForceDefinedInPartSpace: bool
    def __init__(self, ped: Ped) -> None: ...

class LeanInDirectionHelper(CustomHelper):
    LeanAmount: float
    Dir: Vector3
    def __init__(self, ped: Ped) -> None: ...

class LeanRandomHelper(CustomHelper):
    LeanAmountMin: float
    LeanAmountMax: float
    ChangeTimeMin: float
    ChangeTimeMax: float
    def __init__(self, ped: Ped) -> None: ...

class LeanToPositionHelper(CustomHelper):
    LeanAmount: float
    Pos: Vector3
    def __init__(self, ped: Ped) -> None: ...

class LeanTowardsObjectHelper(CustomHelper):
    LeanAmount: float
    Offset: Vector3
    InstanceIndex: int
    BoundIndex: int
    def __init__(self, ped: Ped) -> None: ...

class HipsLeanInDirectionHelper(CustomHelper):
    LeanAmount: float
    Dir: Vector3
    def __init__(self, ped: Ped) -> None: ...

class HipsLeanRandomHelper(CustomHelper):
    LeanAmountMin: float
    LeanAmountMax: float
    ChangeTimeMin: float
    ChangeTimeMax: float
    def __init__(self, ped: Ped) -> None: ...

class HipsLeanToPositionHelper(CustomHelper):
    LeanAmount: float
    Pos: Vector3
    def __init__(self, ped: Ped) -> None: ...

class HipsLeanTowardsObjectHelper(CustomHelper):
    LeanAmount: float
    Offset: Vector3
    InstanceIndex: int
    BoundIndex: int
    def __init__(self, ped: Ped) -> None: ...

class ForceLeanInDirectionHelper(CustomHelper):
    LeanAmount: float
    Dir: Vector3
    BodyPart: int
    def __init__(self, ped: Ped) -> None: ...

class ForceLeanRandomHelper(CustomHelper):
    LeanAmountMin: float
    LeanAmountMax: float
    ChangeTimeMin: float
    ChangeTimeMax: float
    BodyPart: int
    def __init__(self, ped: Ped) -> None: ...

class ForceLeanToPositionHelper(CustomHelper):
    LeanAmount: float
    Pos: Vector3
    BodyPart: int
    def __init__(self, ped: Ped) -> None: ...

class ForceLeanTowardsObjectHelper(CustomHelper):
    LeanAmount: float
    Offset: Vector3
    InstanceIndex: int
    BoundIndex: int
    BodyPart: int
    def __init__(self, ped: Ped) -> None: ...

class SetStiffnessHelper(CustomHelper):
    BodyStiffness: float
    Damping: float
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class SetMuscleStiffnessHelper(CustomHelper):
    MuscleStiffness: float
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class SetWeaponModeHelper(CustomHelper):
    WeaponMode: WeaponMode
    def __init__(self, ped: Ped) -> None: ...

class RegisterWeaponHelper(CustomHelper):
    Hand: Hand
    LevelIndex: int
    ConstraintHandle: int
    GunToHandA: Vector3
    GunToHandB: Vector3
    GunToHandC: Vector3
    GunToHandD: Vector3
    GunToMuzzleInGun: Vector3
    GunToButtInGun: Vector3
    def __init__(self, ped: Ped) -> None: ...

class ShotRelaxHelper(CustomHelper):
    RelaxPeriodUpper: float
    RelaxPeriodLower: float
    def __init__(self, ped: Ped) -> None: ...

class FireWeaponHelper(CustomHelper):
    FiredWeaponStrength: float
    GunHandEnum: Hand
    ApplyFireGunForceAtClavicle: bool
    InhibitTime: float
    Direction: Vector3
    Split: float
    def __init__(self, ped: Ped) -> None: ...

class ConfigureConstraintsHelper(CustomHelper):
    HandCuffs: bool
    HandCuffsBehindBack: bool
    LegCuffs: bool
    RightDominant: bool
    PassiveMode: int
    BespokeBehavior: bool
    Blend2ZeroPose: float
    def __init__(self, ped: Ped) -> None: ...

class StayUprightHelper(CustomHelper):
    UseForces: bool
    UseTorques: bool
    LastStandMode: bool
    LastStandSinkRate: float
    LastStandHorizDamping: float
    LastStandMaxTime: float
    TurnTowardsBullets: bool
    VelocityBased: bool
    TorqueOnlyInAir: bool
    ForceStrength: float
    ForceDamping: float
    ForceFeetMult: float
    ForceSpine3Share: float
    ForceLeanReduction: float
    ForceInAirShare: float
    ForceMin: float
    ForceMax: float
    ForceSaturationVel: float
    ForceThresholdVel: float
    TorqueStrength: float
    TorqueDamping: float
    TorqueSaturationVel: float
    TorqueThresholdVel: float
    SupportPosition: float
    NoSupportForceMult: float
    StepUpHelp: float
    StayUpAcc: float
    StayUpAccMax: float
    def __init__(self, ped: Ped) -> None: ...

class StopAllBehaviorsHelper(CustomHelper):
    def __init__(self, ped: Ped) -> None: ...

class SetCharacterStrengthHelper(CustomHelper):
    CharacterStrength: float
    def __init__(self, ped: Ped) -> None: ...

class SetCharacterHealthHelper(CustomHelper):
    CharacterHealth: float
    def __init__(self, ped: Ped) -> None: ...

class SetFallingReactionHelper(CustomHelper):
    HandsAndKnees: bool
    CallRDS: bool
    ComVelRDSThresh: float
    ResistRolling: bool
    ArmReduceSpeed: float
    ReachLengthMultiplier: float
    InhibitRollingTime: float
    ChangeFrictionTime: float
    GroundFriction: float
    FrictionMin: float
    FrictionMax: float
    StopOnSlopes: bool
    StopManual: float
    StoppedStrengthDecay: float
    SpineLean1Offset: float
    RiflePose: bool
    HkHeadAvoid: bool
    AntiPropClav: bool
    AntiPropWeak: bool
    HeadAsWeakAsArms: bool
    SuccessStrength: float
    def __init__(self, ped: Ped) -> None: ...

class SetCharacterUnderwaterHelper(CustomHelper):
    Underwater: bool
    Viscosity: float
    GravityFactor: float
    Stroke: float
    LinearStroke: bool
    def __init__(self, ped: Ped) -> None: ...

class SetCharacterCollisionsHelper(CustomHelper):
    Spin: float
    MaxVelocity: float
    ApplyToAll: bool
    ApplyToSpine: bool
    ApplyToThighs: bool
    ApplyToClavicles: bool
    ApplyToUpperArms: bool
    FootSlip: bool
    VehicleClass: int
    def __init__(self, ped: Ped) -> None: ...

class SetCharacterDampingHelper(CustomHelper):
    SomersaultThresh: float
    SomersaultDamp: float
    CartwheelThresh: float
    CartwheelDamp: float
    VehicleCollisionTime: float
    V2: bool
    def __init__(self, ped: Ped) -> None: ...

class SetFrictionScaleHelper(CustomHelper):
    Scale: float
    GlobalMin: float
    GlobalMax: float
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class AnimPoseHelper(CustomHelper):
    MuscleStiffness: float
    Stiffness: float
    Damping: float
    EffectorMask: str
    OverideHeadlook: bool
    OveridePointArm: bool
    OveridePointGun: bool
    UseZMPGravityCompensation: bool
    GravityCompensation: float
    MuscleStiffnessLeftArm: float
    MuscleStiffnessRightArm: float
    MuscleStiffnessSpine: float
    MuscleStiffnessLeftLeg: float
    MuscleStiffnessRightLeg: float
    StiffnessLeftArm: float
    StiffnessRightArm: float
    StiffnessSpine: float
    StiffnessLeftLeg: float
    StiffnessRightLeg: float
    DampingLeftArm: float
    DampingRightArm: float
    DampingSpine: float
    DampingLeftLeg: float
    DampingRightLeg: float
    GravCompLeftArm: float
    GravCompRightArm: float
    GravCompSpine: float
    GravCompLeftLeg: float
    GravCompRightLeg: float
    ConnectedLeftHand: int
    ConnectedRightHand: int
    ConnectedLeftFoot: int
    ConnectedRightFoot: int
    AnimSource: AnimSource
    DampenSideMotionInstanceIndex: int
    def __init__(self, ped: Ped) -> None: ...

class ArmsWindmillHelper(CustomHelper):
    LeftPartID: int
    LeftRadius1: float
    LeftRadius2: float
    LeftSpeed: float
    LeftNormal: Vector3
    LeftCentre: Vector3
    RightPartID: int
    RightRadius1: float
    RightRadius2: float
    RightSpeed: float
    RightNormal: Vector3
    RightCentre: Vector3
    ShoulderStiffness: float
    ShoulderDamping: float
    ElbowStiffness: float
    ElbowDamping: float
    LeftElbowMin: float
    RightElbowMin: float
    PhaseOffset: float
    DragReduction: float
    IKtwist: float
    AngVelThreshold: float
    AngVelGain: float
    MirrorMode: MirrorMode
    AdaptiveMode: AdaptiveMode
    ForceSync: bool
    UseLeft: bool
    UseRight: bool
    DisableOnImpact: bool
    def __init__(self, ped: Ped) -> None: ...

class ArmsWindmillAdaptiveHelper(CustomHelper):
    AngSpeed: float
    BodyStiffness: float
    Amplitude: float
    Phase: float
    ArmStiffness: float
    LeftElbowAngle: float
    RightElbowAngle: float
    Lean1mult: float
    Lean1offset: float
    ElbowRate: float
    ArmDirection: ArmDirection
    DisableOnImpact: bool
    SetBackAngles: bool
    UseAngMom: bool
    BendLeftElbow: bool
    BendRightElbow: bool
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class BalancerCollisionsReactionHelper(CustomHelper):
    NumStepsTillSlump: int
    Stable2SlumpTime: float
    ExclusionZone: float
    FootFrictionMultStart: float
    FootFrictionMultRate: float
    BackFrictionMultStart: float
    BackFrictionMultRate: float
    ImpactLegStiffReduction: float
    SlumpLegStiffReduction: float
    SlumpLegStiffRate: float
    ReactTime: float
    ImpactExagTime: float
    GlanceSpinTime: float
    GlanceSpinMag: float
    GlanceSpinDecayMult: float
    IgnoreColWithIndex: int
    SlumpMode: int
    ReboundMode: int
    IgnoreColMassBelow: float
    ForwardMode: int
    TimeToForward: float
    ReboundForce: float
    BraceWall: bool
    IgnoreColVolumeBelow: float
    FallOverWallDrape: bool
    FallOverHighWalls: bool
    Snap: bool
    SnapMag: float
    SnapDirectionRandomness: float
    SnapLeftArm: bool
    SnapRightArm: bool
    SnapLeftLeg: bool
    SnapRightLeg: bool
    SnapSpine: bool
    SnapNeck: bool
    SnapPhasedLegs: bool
    SnapHipType: int
    UnSnapInterval: float
    UnSnapRatio: float
    SnapUseTorques: bool
    ImpactWeaknessZeroDuration: float
    ImpactWeaknessRampDuration: float
    ImpactLoosenessAmount: float
    ObjectBehindVictim: bool
    ObjectBehindVictimPos: Vector3
    ObjectBehindVictimNormal: Vector3
    def __init__(self, ped: Ped) -> None: ...

class BodyBalanceHelper(CustomHelper):
    ArmStiffness: float
    Elbow: float
    Shoulder: float
    ArmDamping: float
    UseHeadLook: bool
    HeadLookPos: Vector3
    HeadLookInstanceIndex: int
    SpineStiffness: float
    SomersaultAngle: float
    SomersaultAngleThreshold: float
    SideSomersaultAngle: float
    SideSomersaultAngleThreshold: float
    BackwardsAutoTurn: bool
    TurnWithBumpRadius: float
    BackwardsArms: bool
    BlendToZeroPose: bool
    ArmsOutOnPush: bool
    ArmsOutOnPushMultiplier: float
    ArmsOutOnPushTimeout: float
    ReturningToBalanceArmsOut: float
    ArmsOutStraightenElbows: float
    ArmsOutMinLean2: float
    SpineDamping: float
    UseBodyTurn: bool
    ElbowAngleOnContact: float
    BendElbowsTime: float
    BendElbowsGait: float
    HipL2ArmL2: float
    ShoulderL2: float
    ShoulderL1: float
    ShoulderTwist: float
    HeadLookAtVelProb: float
    TurnOffProb: float
    Turn2VelProb: float
    TurnAwayProb: float
    TurnLeftProb: float
    TurnRightProb: float
    Turn2TargetProb: float
    AngVelMultiplier: Vector3
    AngVelThreshold: Vector3
    BraceDistance: float
    TargetPredictionTime: float
    ReachAbsorbtionTime: float
    BraceStiffness: float
    MinBraceTime: float
    TimeToBackwardsBrace: float
    HandsDelayMin: float
    HandsDelayMax: float
    BraceOffset: float
    MoveRadius: float
    MoveAmount: float
    MoveWhenBracing: bool
    def __init__(self, ped: Ped) -> None: ...

class BodyFoetalHelper(CustomHelper):
    Stiffness: float
    DampingFactor: float
    Asymmetry: float
    RandomSeed: int
    BackTwist: float
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class BodyRollUpHelper(CustomHelper):
    Stiffness: float
    UseArmToSlowDown: float
    ArmReachAmount: float
    Mask: str
    LegPush: float
    AsymmetricalLegs: float
    NoRollTimeBeforeSuccess: float
    RollVelForSuccess: float
    RollVelLinearContribution: float
    VelocityScale: float
    VelocityOffset: float
    ApplyMinMaxFriction: bool
    def __init__(self, ped: Ped) -> None: ...

class BodyWritheHelper(CustomHelper):
    ArmStiffness: float
    BackStiffness: float
    LegStiffness: float
    ArmDamping: float
    BackDamping: float
    LegDamping: float
    ArmPeriod: float
    BackPeriod: float
    LegPeriod: float
    Mask: str
    ArmAmplitude: float
    BackAmplitude: float
    LegAmplitude: float
    ElbowAmplitude: float
    KneeAmplitude: float
    RollOverFlag: bool
    BlendArms: float
    BlendBack: float
    BlendLegs: float
    ApplyStiffness: bool
    OnFire: bool
    ShoulderLean1: float
    ShoulderLean2: float
    Lean1BlendFactor: float
    Lean2BlendFactor: float
    RollTorqueScale: float
    MaxRollOverTime: float
    RollOverRadius: float
    def __init__(self, ped: Ped) -> None: ...

class BraceForImpactHelper(CustomHelper):
    BraceDistance: float
    TargetPredictionTime: float
    ReachAbsorbtionTime: float
    InstanceIndex: int
    BodyStiffness: float
    GrabDontLetGo: bool
    GrabStrength: float
    GrabDistance: float
    GrabReachAngle: float
    GrabHoldTimer: float
    MaxGrabCarVelocity: float
    LegStiffness: float
    TimeToBackwardsBrace: float
    Look: Vector3
    Pos: Vector3
    MinBraceTime: float
    HandsDelayMin: float
    HandsDelayMax: float
    MoveAway: bool
    MoveAwayAmount: float
    MoveAwayLean: float
    MoveSideways: float
    BbArms: bool
    NewBrace: bool
    BraceOnImpact: bool
    Roll2Velocity: bool
    RollType: int
    SnapImpacts: bool
    SnapImpact: float
    SnapBonnet: float
    SnapFloor: float
    DampVel: bool
    DampSpin: float
    DampUpVel: float
    DampSpinThresh: float
    DampUpVelThresh: float
    GsHelp: bool
    GsEndMin: float
    GsSideMin: float
    GsSideMax: float
    GsUpness: float
    GsCarVelMin: float
    GsScale1Foot: bool
    GsFricScale1: float
    GsFricMask1: str
    GsFricScale2: float
    GsFricMask2: str
    def __init__(self, ped: Ped) -> None: ...

class BuoyancyHelper(CustomHelper):
    SurfacePoint: Vector3
    SurfaceNormal: Vector3
    Buoyancy: float
    ChestBuoyancy: float
    Damping: float
    Righting: bool
    RightingStrength: float
    RightingTime: float
    def __init__(self, ped: Ped) -> None: ...

class CatchFallHelper(CustomHelper):
    TorsoStiffness: float
    LegsStiffness: float
    ArmsStiffness: float
    BackwardsMinArmOffset: float
    ForwardMaxArmOffset: float
    ZAxisSpinReduction: float
    ExtraSit: float
    UseHeadLook: bool
    Mask: str
    def __init__(self, ped: Ped) -> None: ...

class ElectrocuteHelper(CustomHelper):
    StunMag: float
    InitialMult: float
    LargeMult: float
    LargeMinTime: float
    LargeMaxTime: float
    MovingMult: float
    BalancingMult: float
    AirborneMult: float
    MovingThresh: float
    StunInterval: float
    DirectionRandomness: float
    LeftArm: bool
    RightArm: bool
    LeftLeg: bool
    RightLeg: bool
    Spine: bool
    Neck: bool
    PhasedLegs: bool
    ApplyStiffness: bool
    UseTorques: bool
    HipType: int
    def __init__(self, ped: Ped) -> None: ...

class FallOverWallHelper(CustomHelper):
    BodyStiffness: float
    Damping: float
    MagOfForce: float
    MaxDistanceFromPelToHitPoint: float
    MaxForceDist: float
    StepExclusionZone: float
    MinLegHeight: float
    BodyTwist: float
    MaxTwist: float
    FallOverWallEndA: Vector3
    FallOverWallEndB: Vector3
    ForceAngleAbort: float
    ForceTimeOut: float
    MoveArms: bool
    MoveLegs: bool
    BendSpine: bool
    AngleDirWithWallNormal: float
    LeaningAngleThreshold: float
    MaxAngVel: float
    AdaptForcesToLowWall: bool
    MaxWallHeight: float
    DistanceToSendSuccessMessage: float
    RollingBackThr: float
    RollingPotential: float
    UseArmIK: bool
    ReachDistanceFromHitPoint: float
    MinReachDistanceFromHitPoint: float
    AngleTotallyBack: float
    def __init__(self, ped: Ped) -> None: ...

class GrabHelper(CustomHelper):
    UseLeft: bool
    UseRight: bool
    DropWeaponIfNecessary: bool
    DropWeaponDistance: float
    GrabStrength: float
    StickyHands: float
    TurnToTarget: TurnType
    GrabHoldMaxTimer: float
    PullUpTime: float
    PullUpStrengthRight: float
    PullUpStrengthLeft: float
    Pos1: Vector3
    Pos2: Vector3
    Pos3: Vector3
    Pos4: Vector3
    NormalR: Vector3
    NormalL: Vector3
    NormalR2: Vector3
    NormalL2: Vector3
    HandsCollide: bool
    JustBrace: bool
    UseLineGrab: bool
    PointsX4grab: bool
    FromEA: bool
    SurfaceGrab: bool
    InstanceIndex: int
    InstancePartIndex: int
    DontLetGo: bool
    BodyStiffness: float
    ReachAngle: float
    OneSideReachAngle: float
    GrabDistance: float
    Move2Radius: float
    ArmStiffness: float
    MaxReachDistance: float
    OrientationConstraintScale: float
    MaxWristAngle: float
    UseHeadLookToTarget: bool
    LookAtGrab: bool
    TargetForHeadLook: Vector3
    def __init__(self, ped: Ped) -> None: ...

class HeadLookHelper(CustomHelper):
    Damping: float
    Stiffness: float
    InstanceIndex: int
    Vel: Vector3
    Pos: Vector3
    AlwaysLook: bool
    EyesHorizontal: bool
    AlwaysEyesHorizontal: bool
    KeepHeadAwayFromGround: bool
    TwistSpine: bool
    def __init__(self, ped: Ped) -> None: ...

class HighFallHelper(CustomHelper):
    BodyStiffness: float
    Bodydamping: float
    Catchfalltime: float
    CrashOrLandCutOff: float
    PdStrength: float
    PdDamping: float
    ArmAngSpeed: float
    ArmAmplitude: float
    ArmPhase: float
    ArmBendElbows: bool
    LegRadius: float
    LegAngSpeed: float
    LegAsymmetry: float
    Arms2LegsPhase: float
    Arms2LegsSync: Synchroisation
    ArmsUp: float
    OrientateBodyToFallDirection: bool
    OrientateTwist: bool
    OrientateMax: float
    AlanRickman: bool
    FowardRoll: bool
    UseZeroPose_withFowardRoll: bool
    AimAngleBase: float
    FowardVelRotation: float
    FootVelCompScale: float
    SideD: float
    FowardOffsetOfLegIK: float
    LegL: float
    CatchFallCutOff: float
    LegStrength: float
    Balance: bool
    IgnorWorldCollisions: bool
    AdaptiveCircling: bool
    Hula: bool
    MaxSpeedForRecoverableFall: float
    MinSpeedForBrace: float
    LandingNormal: float
    def __init__(self, ped: Ped) -> None: ...

class IncomingTransformsHelper(CustomHelper):
    def __init__(self, ped: Ped) -> None: ...

class InjuredOnGroundHelper(CustomHelper):
    NumInjuries: int
    Injury1Component: int
    Injury2Component: int
    Injury1LocalPosition: Vector3
    Injury2LocalPosition: Vector3
    Injury1LocalNormal: Vector3
    Injury2LocalNormal: Vector3
    AttackerPos: Vector3
    DontReachWithLeft: bool
    DontReachWithRight: bool
    StrongRollForce: bool
    def __init__(self, ped: Ped) -> None: ...

class CarriedHelper(CustomHelper):
    def __init__(self, ped: Ped) -> None: ...

class DangleHelper(CustomHelper):
    DoGrab: bool
    GrabFrequency: float
    def __init__(self, ped: Ped) -> None: ...

class OnFireHelper(CustomHelper):
    StaggerTime: float
    StaggerLeanRate: float
    StumbleMaxLeanBack: float
    StumbleMaxLeanForward: float
    ArmsWindmillWritheBlend: float
    SpineStumbleWritheBlend: float
    LegsStumbleWritheBlend: float
    ArmsPoseWritheBlend: float
    SpinePoseWritheBlend: float
    LegsPoseWritheBlend: float
    RollOverFlag: bool
    RollTorqueScale: float
    PredictTime: float
    MaxRollOverTime: float
    RollOverRadius: float
    def __init__(self, ped: Ped) -> None: ...

class PedalLegsHelper(CustomHelper):
    PedalLeftLeg: bool
    PedalRightLeg: bool
    BackPedal: bool
    Radius: float
    AngularSpeed: float
    LegStiffness: float
    PedalOffset: float
    RandomSeed: int
    SpeedAsymmetry: float
    AdaptivePedal4Dragging: bool
    AngSpeedMultiplier4Dragging: float
    RadiusVariance: float
    LegAngleVariance: float
    CentreSideways: float
    CentreForwards: float
    CentreUp: float
    Ellipse: float
    DragReduction: float
    Spread: float
    Hula: bool
    def __init__(self, ped: Ped) -> None: ...

class PointArmHelper(CustomHelper):
    TargetLeft: Vector3
    TwistLeft: float
    ArmStraightnessLeft: float
    UseLeftArm: bool
    ArmStiffnessLeft: float
    ArmDampingLeft: float
    InstanceIndexLeft: int
    PointSwingLimitLeft: float
    UseZeroPoseWhenNotPointingLeft: bool
    TargetRight: Vector3
    TwistRight: float
    ArmStraightnessRight: float
    UseRightArm: bool
    ArmStiffnessRight: float
    ArmDampingRight: float
    InstanceIndexRight: int
    PointSwingLimitRight: float
    UseZeroPoseWhenNotPointingRight: bool
    def __init__(self, ped: Ped) -> None: ...

class PointGunHelper(CustomHelper):
    EnableRight: bool
    EnableLeft: bool
    LeftHandTarget: Vector3
    LeftHandTargetIndex: int
    RightHandTarget: Vector3
    RightHandTargetIndex: int
    LeadTarget: float
    ArmStiffness: float
    ArmStiffnessDetSupport: float
    ArmDamping: float
    GravityOpposition: float
    GravOppDetachedSupport: float
    MassMultDetachedSupport: float
    AllowShotLooseness: bool
    ClavicleBlend: float
    ElbowAttitude: float
    SupportConstraint: int
    ConstraintMinDistance: float
    MakeConstraintDistance: float
    ReduceConstraintLengthVel: float
    BreakingStrength: float
    BrokenSupportTime: float
    BrokenToSideProb: float
    ConnectAfter: float
    ConnectFor: float
    OneHandedPointing: int
    AlwaysSupport: bool
    PoseUnusedGunArm: bool
    PoseUnusedSupportArm: bool
    PoseUnusedOtherArm: bool
    MaxAngleAcross: float
    MaxAngleAway: float
    FallingLimits: int
    AcrossLimit: float
    AwayLimit: float
    UpLimit: float
    DownLimit: float
    RifleFall: int
    FallingSupport: int
    FallingTypeSupport: int
    PistolNeutralType: int
    NeutralPoint4Pistols: bool
    NeutralPoint4Rifle: bool
    CheckNeutralPoint: bool
    Point2Side: Vector3
    Add2WeaponDistSide: float
    Point2Connect: Vector3
    Add2WeaponDistConnect: float
    UsePistolIK: bool
    UseSpineTwist: bool
    UseTurnToTarget: bool
    UseHeadLook: bool
    ErrorThreshold: float
    FireWeaponRelaxTime: float
    FireWeaponRelaxAmount: float
    FireWeaponRelaxDistance: float
    UseIncomingTransforms: bool
    MeasureParentOffset: bool
    LeftHandParentOffset: Vector3
    LeftHandParentEffector: int
    RightHandParentOffset: Vector3
    RightHandParentEffector: int
    PrimaryHandWeaponDistance: float
    ConstrainRifle: bool
    RifleConstraintMinDistance: float
    DisableArmCollisions: bool
    DisableRifleCollisions: bool
    def __init__(self, ped: Ped) -> None: ...

class PointGunExtraHelper(CustomHelper):
    ConstraintStrength: float
    ConstraintThresh: float
    WeaponMask: int
    TimeWarpActive: bool
    TimeWarpStrengthScale: float
    OriStiff: float
    OriDamp: float
    PosStiff: float
    PosDamp: float
    def __init__(self, ped: Ped) -> None: ...

class RollDownStairsHelper(CustomHelper):
    Stiffness: float
    Damping: float
    Forcemag: float
    M_useArmToSlowDown: float
    UseZeroPose: bool
    SpinWhenInAir: bool
    M_armReachAmount: float
    M_legPush: float
    TryToAvoidHeadButtingGround: bool
    ArmReachLength: float
    CustomRollDir: Vector3
    UseCustomRollDir: bool
    StiffnessDecayTarget: float
    StiffnessDecayTime: float
    AsymmetricalLegs: float
    ZAxisSpinReduction: float
    TargetLinearVelocityDecayTime: float
    TargetLinearVelocity: float
    OnlyApplyHelperForces: bool
    UseVelocityOfObjectBelow: bool
    UseRelativeVelocity: bool
    ApplyFoetalToLegs: bool
    MovementLegsInFoetalPosition: float
    MaxAngVelAroundFrontwardAxis: float
    MinAngVel: float
    ApplyNewRollingCheatingTorques: bool
    MaxAngVel: float
    MagOfTorqueToRoll: float
    ApplyHelPerTorqueToAlign: bool
    DelayToAlignBody: float
    MagOfTorqueToAlign: float
    AirborneReduction: float
    ApplyMinMaxFriction: bool
    LimitSpinReduction: bool
    def __init__(self, ped: Ped) -> None: ...

class ShotHelper(CustomHelper):
    BodyStiffness: float
    SpineDamping: float
    ArmStiffness: float
    InitialNeckStiffness: float
    InitialNeckDamping: float
    NeckStiffness: float
    NeckDamping: float
    KMultOnLoose: float
    KMult4Legs: float
    LoosenessAmount: float
    Looseness4Fall: float
    Looseness4Stagger: float
    MinArmsLooseness: float
    MinLegsLooseness: float
    GrabHoldTime: float
    SpineBlendExagCPain: bool
    SpineBlendZero: float
    BulletProofVest: bool
    AlwaysResetLooseness: bool
    AlwaysResetNeckLooseness: bool
    AngVelScale: float
    AngVelScaleMask: str
    FlingWidth: float
    FlingTime: float
    TimeBeforeReachForWound: float
    ExagDuration: float
    ExagMag: float
    ExagTwistMag: float
    ExagSmooth2Zero: float
    ExagZeroTime: float
    CpainSmooth2Time: float
    CpainDuration: float
    CpainMag: float
    CpainTwistMag: float
    CpainSmooth2Zero: float
    Crouching: bool
    ChickenArms: bool
    ReachForWound: bool
    Fling: bool
    AllowInjuredArm: bool
    AllowInjuredLeg: bool
    AllowInjuredLowerLegReach: bool
    AllowInjuredThighReach: bool
    StableHandsAndNeck: bool
    Melee: bool
    FallingReaction: int
    UseExtendedCatchFall: bool
    InitialWeaknessZeroDuration: float
    InitialWeaknessRampDuration: float
    InitialNeckDuration: float
    InitialNeckRampDuration: float
    UseCStrModulation: bool
    CStrUpperMin: float
    CStrUpperMax: float
    CStrLowerMin: float
    CStrLowerMax: float
    DeathTime: float
    def __init__(self, ped: Ped) -> None: ...

class ShotNewBulletHelper(CustomHelper):
    BodyPart: int
    LocalHitPointInfo: bool
    Normal: Vector3
    HitPoint: Vector3
    BulletVel: Vector3
    def __init__(self, ped: Ped) -> None: ...

class ShotSnapHelper(CustomHelper):
    Snap: bool
    SnapMag: float
    SnapMovingMult: float
    SnapBalancingMult: float
    SnapAirborneMult: float
    SnapMovingThresh: float
    SnapDirectionRandomness: float
    SnapLeftArm: bool
    SnapRightArm: bool
    SnapLeftLeg: bool
    SnapRightLeg: bool
    SnapSpine: bool
    SnapNeck: bool
    SnapPhasedLegs: bool
    SnapHipType: int
    SnapUseBulletDir: bool
    SnapHitPart: bool
    UnSnapInterval: float
    UnSnapRatio: float
    SnapUseTorques: bool
    def __init__(self, ped: Ped) -> None: ...

class ShotShockSpinHelper(CustomHelper):
    AddShockSpin: bool
    RandomizeShockSpinDirection: bool
    AlwaysAddShockSpin: bool
    ShockSpinMin: float
    ShockSpinMax: float
    ShockSpinLiftForceMult: float
    ShockSpinDecayMult: float
    ShockSpinScalePerComponent: float
    ShockSpinMaxTwistVel: float
    ShockSpinScaleByLeverArm: bool
    ShockSpinAirMult: float
    ShockSpin1FootMult: float
    ShockSpinFootGripMult: float
    BracedSideSpinMult: float
    def __init__(self, ped: Ped) -> None: ...

class ShotFallToKneesHelper(CustomHelper):
    FallToKnees: bool
    FtkAlwaysChangeFall: bool
    FtkBalanceTime: float
    FtkHelperForce: float
    FtkHelperForceOnSpine: bool
    FtkLeanHelp: float
    FtkSpineBend: float
    FtkStiffSpine: bool
    FtkImpactLooseness: float
    FtkImpactLoosenessTime: float
    FtkBendRate: float
    FtkHipBlend: float
    FtkLungeProb: float
    FtkKneeSpin: bool
    FtkFricMult: float
    FtkHipAngleFall: float
    FtkPitchForwards: float
    FtkPitchBackwards: float
    FtkFallBelowStab: float
    FtkBalanceAbortThreshold: float
    FtkOnKneesArmType: int
    FtkReleaseReachForWound: float
    FtkReachForWound: bool
    FtkReleasePointGun: bool
    FtkFailMustCollide: bool
    def __init__(self, ped: Ped) -> None: ...

class ShotFromBehindHelper(CustomHelper):
    ShotFromBehind: bool
    SfbSpineAmount: float
    SfbNeckAmount: float
    SfbHipAmount: float
    SfbKneeAmount: float
    SfbPeriod: float
    SfbForceBalancePeriod: float
    SfbArmsOnset: float
    SfbKneesOnset: float
    SfbNoiseGain: float
    SfbIgnoreFail: int
    def __init__(self, ped: Ped) -> None: ...

class ShotInGutsHelper(CustomHelper):
    ShotInGuts: bool
    SigSpineAmount: float
    SigNeckAmount: float
    SigHipAmount: float
    SigKneeAmount: float
    SigPeriod: float
    SigForceBalancePeriod: float
    SigKneesOnset: float
    def __init__(self, ped: Ped) -> None: ...

class ShotHeadLookHelper(CustomHelper):
    UseHeadLook: bool
    HeadLook: Vector3
    HeadLookAtWoundMinTimer: float
    HeadLookAtWoundMaxTimer: float
    HeadLookAtHeadPosMaxTimer: float
    HeadLookAtHeadPosMinTimer: float
    def __init__(self, ped: Ped) -> None: ...

class ShotConfigureArmsHelper(CustomHelper):
    Brace: bool
    PointGun: bool
    UseArmsWindmill: bool
    ReleaseWound: int
    ReachFalling: int
    ReachFallingWithOneHand: int
    ReachOnFloor: int
    AlwaysReachTime: float
    AWSpeedMult: float
    AWRadiusMult: float
    AWStiffnessAdd: float
    ReachWithOneHand: int
    AllowLeftPistolRFW: bool
    AllowRightPistolRFW: bool
    RfwWithPistol: bool
    Fling2: bool
    Fling2Left: bool
    Fling2Right: bool
    Fling2OverrideStagger: bool
    Fling2TimeBefore: float
    Fling2Time: float
    Fling2MStiffL: float
    Fling2MStiffR: float
    Fling2RelaxTimeL: float
    Fling2RelaxTimeR: float
    Fling2AngleMinL: float
    Fling2AngleMaxL: float
    Fling2AngleMinR: float
    Fling2AngleMaxR: float
    Fling2LengthMinL: float
    Fling2LengthMaxL: float
    Fling2LengthMinR: float
    Fling2LengthMaxR: float
    Bust: bool
    BustElbowLift: float
    CupSize: float
    CupBust: bool
    def __init__(self, ped: Ped) -> None: ...

class SmartFallHelper(CustomHelper):
    BodyStiffness: float
    Bodydamping: float
    Catchfalltime: float
    CrashOrLandCutOff: float
    PdStrength: float
    PdDamping: float
    ArmAngSpeed: float
    ArmAmplitude: float
    ArmPhase: float
    ArmBendElbows: bool
    LegRadius: float
    LegAngSpeed: float
    LegAsymmetry: float
    Arms2LegsPhase: float
    Arms2LegsSync: Synchroisation
    ArmsUp: float
    OrientateBodyToFallDirection: bool
    OrientateTwist: bool
    OrientateMax: float
    AlanRickman: bool
    FowardRoll: bool
    UseZeroPose_withFowardRoll: bool
    AimAngleBase: float
    FowardVelRotation: float
    FootVelCompScale: float
    SideD: float
    FowardOffsetOfLegIK: float
    LegL: float
    CatchFallCutOff: float
    LegStrength: float
    Balance: bool
    IgnorWorldCollisions: bool
    AdaptiveCircling: bool
    Hula: bool
    MaxSpeedForRecoverableFall: float
    MinSpeedForBrace: float
    LandingNormal: float
    RdsForceMag: float
    RdsTargetLinVeDecayTime: float
    RdsTargetLinearVelocity: float
    RdsUseStartingFriction: bool
    RdsStartingFriction: float
    RdsStartingFrictionMin: float
    RdsForceVelThreshold: float
    InitialState: int
    ChangeExtremityFriction: bool
    Teeter: bool
    TeeterOffset: float
    StopRollingTime: float
    ReboundScale: float
    ReboundMask: str
    ForceHeadAvoid: bool
    CfZAxisSpinReduction: float
    SplatWhenStopped: float
    BlendHeadWhenStopped: float
    SpreadLegs: float
    def __init__(self, ped: Ped) -> None: ...

class StaggerFallHelper(CustomHelper):
    ArmStiffness: float
    ArmDamping: float
    SpineDamping: float
    SpineStiffness: float
    ArmStiffnessStart: float
    ArmDampingStart: float
    SpineDampingStart: float
    SpineStiffnessStart: float
    TimeAtStartValues: float
    RampTimeFromStartValues: float
    StaggerStepProb: float
    StepsTillStartEnd: int
    TimeStartEnd: float
    RampTimeToEndValues: float
    LowerBodyStiffness: float
    LowerBodyStiffnessEnd: float
    PredictionTime: float
    PerStepReduction1: float
    LeanInDirRate: float
    LeanInDirMaxF: float
    LeanInDirMaxB: float
    LeanHipsMaxF: float
    LeanHipsMaxB: float
    Lean2multF: float
    Lean2multB: float
    PushOffDist: float
    MaxPushoffVel: float
    HipBendMult: float
    AlwaysBendForwards: bool
    SpineBendMult: float
    UseHeadLook: bool
    HeadLookPos: Vector3
    HeadLookInstanceIndex: int
    HeadLookAtVelProb: float
    TurnOffProb: float
    Turn2TargetProb: float
    Turn2VelProb: float
    TurnAwayProb: float
    TurnLeftProb: float
    TurnRightProb: float
    UseBodyTurn: bool
    UpperBodyReaction: bool
    def __init__(self, ped: Ped) -> None: ...

class TeeterHelper(CustomHelper):
    EdgeLeft: Vector3
    EdgeRight: Vector3
    UseExclusionZone: bool
    UseHeadLook: bool
    CallHighFall: bool
    LeanAway: bool
    PreTeeterTime: float
    LeanAwayTime: float
    LeanAwayScale: float
    TeeterTime: float
    def __init__(self, ped: Ped) -> None: ...

class UpperBodyFlinchHelper(CustomHelper):
    HandDistanceLeftRight: float
    HandDistanceFrontBack: float
    HandDistanceVertical: float
    BodyStiffness: float
    BodyDamping: float
    BackBendAmount: float
    UseRightArm: bool
    UseLeftArm: bool
    NoiseScale: float
    NewHit: bool
    ProtectHeadToggle: bool
    DontBraceHead: bool
    ApplyStiffness: bool
    HeadLookAwayFromTarget: bool
    UseHeadLook: bool
    TurnTowards: int
    Pos: Vector3
    def __init__(self, ped: Ped) -> None: ...

class YankedHelper(CustomHelper):
    ArmStiffness: float
    ArmDamping: float
    SpineDamping: float
    SpineStiffness: float
    ArmStiffnessStart: float
    ArmDampingStart: float
    SpineDampingStart: float
    SpineStiffnessStart: float
    TimeAtStartValues: float
    RampTimeFromStartValues: float
    StepsTillStartEnd: int
    TimeStartEnd: float
    RampTimeToEndValues: float
    LowerBodyStiffness: float
    LowerBodyStiffnessEnd: float
    PerStepReduction: float
    HipPitchForward: float
    HipPitchBack: float
    SpineBend: float
    FootFriction: float
    TurnThresholdMin: float
    TurnThresholdMax: float
    UseHeadLook: bool
    HeadLookPos: Vector3
    HeadLookInstanceIndex: int
    HeadLookAtVelProb: float
    ComVelRDSThresh: float
    HulaPeriod: float
    HipAmplitude: float
    SpineAmplitude: float
    MinRelaxPeriod: float
    MaxRelaxPeriod: float
    RollHelp: float
    GroundLegStiffness: float
    GroundArmStiffness: float
    GroundSpineStiffness: float
    GroundLegDamping: float
    GroundArmDamping: float
    GroundSpineDamping: float
    GroundFriction: float
    def __init__(self, ped: Ped) -> None: ...

class Message:
    def __init__(self, message: str) -> None: ...
    def Abort(self, target: Ped) -> None: ...
    @overload
    def SendTo(self, target: Ped) -> None: ...
    @overload
    def SendTo(self, target: Ped, duration: int) -> None: ...
    def SendTo(self, *args: Any, **kwargs: Any) -> Any: ...
    @overload
    def SetArgument(self, argName: str, value: bool) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: int) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: float) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: str) -> None: ...
    @overload
    def SetArgument(self, argName: str, value: Vector3) -> None: ...
    def SetArgument(self, *args: Any, **kwargs: Any) -> Any: ...
    def RemoveArgument(self, argName: str) -> bool: ...
    def ResetArguments(self) -> None: ...
    def CreateBoolIntFloatArgDictIfNotCreated(self) -> None: ...
    def CreateStringVector3ArrayArgDictIfNotCreated(self) -> None: ...
    def ToString(self) -> str: ...
